/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import jclass.util.LocaleBundle;

public class MessageDialog
implements Runnable,
Serializable,
ActionListener,
WindowListener,
KeyListener {
    static final long serialVersionUID = 760906332180398782L;
    private Frame frame = null;
    private boolean useOwnFrame = false;
    private Dialog dialog = null;
    private String title = "";
    private Panel buttonPanel = new Panel();
    private ActionListener listener = null;
    private String closeWindowCommand = "Close";

    MessageDialog() {
    }

    public MessageDialog(Frame frame, String string, String string2) {
        this();
        if (frame == null) {
            frame = new Frame();
        }
        this.setFrame(frame);
        if (string != null) {
            this.setTitle(string);
        }
        this.addButton(LocaleBundle.string("OK"), null);
        this.show(string2);
    }

    public void run() {
        ((Component)this.dialog).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.listener != null) {
            this.listener.actionPerformed(actionEvent);
        }
        ((Component)this.dialog).setVisible(false);
        this.dialog.dispose();
        if (this.useOwnFrame) {
            this.frame.dispose();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.fireCloseWindowEvent();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.fireCloseWindowEvent();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    void fireCloseWindowEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.closeWindowCommand);
        this.actionPerformed(actionEvent);
    }

    public void setActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setCloseWindowCommand(String string) {
        this.closeWindowCommand = string;
    }

    public void addButton(String string, String string2) {
        Button button = new Button(string);
        if (string2 == null) {
            string2 = string;
        }
        button.setActionCommand(string2);
        button.addActionListener(this);
        button.addKeyListener(this);
        this.buttonPanel.add(button);
    }

    public void show(String string) {
        if (this.frame == null) {
            this.frame = new Frame();
            this.useOwnFrame = true;
        } else {
            this.useOwnFrame = false;
        }
        this.dialog = new Dialog(this.frame, true);
        this.dialog.addWindowListener(this);
        this.dialog.addKeyListener(this);
        this.dialog.setTitle(this.title);
        this.dialog.setLayout(new BorderLayout(5, 5));
        Panel panel = this.createMessagePanel(string);
        this.dialog.add((Component)panel, "Center");
        this.dialog.add((Component)this.buttonPanel, "South");
        this.setDialogSize(200, 100);
        this.dialog.pack();
        this.centerDialog();
        Toolkit.getDefaultToolkit().beep();
        Thread thread = new Thread(this);
        thread.start();
    }

    Panel createMessagePanel(String string) {
        int n = 0;
        if (string == null) {
            string = "";
        }
        String string2 = new String(string);
        while (string2.length() > 0) {
            int n2 = string2.indexOf(10);
            string2 = n2 >= 0 ? string2.substring(n2 + 1) : "";
            ++n;
        }
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(n, 1));
        string2 = new String(string);
        int n3 = 0;
        while (n3 < n) {
            String string3;
            int n4 = string2.indexOf(10);
            if (n4 >= 0) {
                string3 = string2.substring(0, n4);
                string2 = string2.substring(n4 + 1);
            } else {
                string3 = string2;
                string2 = "";
            }
            Label label = new Label("  " + string3);
            panel.add(label);
            ++n3;
        }
        return panel;
    }

    void setDialogSize(int n, int n2) {
        n = Math.max(n, this.dialog.getSize().width);
        n2 = Math.max(n2, this.dialog.getSize().height);
        ((Component)this.dialog).setSize(n, n2);
    }

    void centerDialog() {
        int n = 0;
        int n2 = 0;
        if (!this.useOwnFrame) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n = (dimension.width - this.dialog.getSize().width) / 2;
            n2 = (dimension.height - this.dialog.getSize().height) / 2;
        } else {
            n = this.frame.getBounds().x + (this.frame.getBounds().width - this.dialog.getBounds().width) / 2;
            n2 = this.frame.getBounds().y + (this.frame.getBounds().height - this.dialog.getBounds().height) / 2;
        }
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        ((Component)this.dialog).setLocation(n, n2);
    }
}

